/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import xaero.common.MinimapLogs;

public class ImprovedFramebuffer
extends TextureTarget {
    private int type;
    public int colorTextureId;
    private int depthBufferId;
    private boolean superConstructorWorks;
    private static boolean optifineChecked;
    private static boolean forceMainFBO;
    private static int forcedMainFBO;
    private static final int GL_FB_INCOMPLETE_ATTACHMENT = 36054;
    private static final int GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
    private static final int GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
    private static final int GL_FB_INCOMPLETE_READ_BUFFER = 36060;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(width, height, useDepthIn, Minecraft.f_91002_);
        if (!this.superConstructorWorks) {
            this.m_83941_(width, height, Minecraft.f_91002_);
        }
    }

    public static void detectOptifineFBOs() {
        int actualResult = GL11.glGetInteger((int)36006);
        if (actualResult != Minecraft.m_91087_().m_91385_().f_83920_) {
            MinimapLogs.LOGGER.info("(Minimap) Detected main FBO: " + actualResult);
            forceMainFBO = true;
            forcedMainFBO = actualResult;
        }
    }

    public void m_83941_(int width, int height, boolean isMac) {
        if (!optifineChecked) {
            ImprovedFramebuffer.detectOptifineFBOs();
            optifineChecked = true;
        }
        this.superConstructorWorks = true;
        GlStateManager._enableDepthTest();
        if (this.f_83920_ >= 0) {
            this.m_83930_();
        }
        this.m_83950_(width, height, isMac);
        ImprovedFramebuffer.beginWrite(this.type, 36160, 0);
    }

    public void m_83950_(int width, int height, boolean isMac) {
        this.f_83917_ = width;
        this.f_83918_ = height;
        this.f_83915_ = width;
        this.f_83916_ = height;
        this.f_83920_ = this.genFrameBuffers();
        if (this.f_83920_ == -1) {
            this.m_83954_(isMac);
            return;
        }
        this.colorTextureId = TextureUtil.generateTextureId();
        if (this.colorTextureId == -1) {
            this.m_83954_(isMac);
            return;
        }
        if (this.f_83919_) {
            this.depthBufferId = this.genRenderbuffers();
            if (this.depthBufferId == -1) {
                this.m_83954_(isMac);
                return;
            }
        }
        this.m_83936_(9728);
        GlStateManager._bindTexture((int)this.colorTextureId);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.f_83915_, (int)this.f_83916_, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        ImprovedFramebuffer.beginWrite(this.type, 36160, this.f_83920_);
        ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.colorTextureId, 0);
        if (this.f_83919_) {
            ImprovedFramebuffer.bindRenderbuffer(this.type, 36161, this.depthBufferId);
            ImprovedFramebuffer.renderbufferStorage(this.type, 36161, 33190, this.f_83915_, this.f_83916_);
            ImprovedFramebuffer.framebufferRenderbuffer(this.type, 36160, 36096, 36161, this.depthBufferId);
        }
        this.m_83949_();
        this.m_83954_(isMac);
        this.m_83963_();
    }

    private int genFrameBuffers() {
        int fbo = -1;
        fbo = GlStateManager.glGenFramebuffers();
        this.type = 0;
        return fbo;
    }

    public int genRenderbuffers() {
        int rbo = -1;
        switch (this.type) {
            case 0: {
                rbo = GlStateManager.glGenRenderbuffers();
            }
        }
        return rbo;
    }

    public void m_83930_() {
        this.m_83963_();
        this.m_83970_();
        if (this.depthBufferId > -1) {
            this.deleteRenderbuffers(this.depthBufferId);
            this.depthBufferId = -1;
        }
        if (this.colorTextureId > -1) {
            TextureUtil.releaseTextureId((int)this.colorTextureId);
            this.colorTextureId = -1;
        }
        if (this.f_83920_ > -1) {
            ImprovedFramebuffer.beginWrite(this.type, 36160, 0);
            this.deleteFramebuffers(this.f_83920_);
            this.f_83920_ = -1;
        }
    }

    private void deleteFramebuffers(int framebufferIn) {
        switch (this.type) {
            case 0: {
                GlStateManager._glDeleteFramebuffers((int)framebufferIn);
            }
        }
    }

    private void deleteRenderbuffers(int renderbuffer) {
        switch (this.type) {
            case 0: {
                GlStateManager._glDeleteRenderbuffers((int)renderbuffer);
            }
        }
    }

    public void m_83949_() {
        int i = this.checkFramebufferStatus(36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    private int checkFramebufferStatus(int target) {
        switch (this.type) {
            case 0: {
                return GlStateManager.glCheckFramebufferStatus((int)target);
            }
        }
        return -1;
    }

    private static void beginWrite(int type, int target, int framebufferIn) {
        if (framebufferIn == -1) {
            framebufferIn = 0;
        }
        switch (type) {
            case 0: {
                GlStateManager._glBindFramebuffer((int)target, (int)framebufferIn);
            }
        }
    }

    public void bindDefaultFramebuffer(Minecraft mc) {
        ImprovedFramebuffer.beginWrite(this.getType(), 36160, forceMainFBO ? forcedMainFBO : mc.m_91385_().f_83920_);
        mc.m_91385_().m_83947_(false);
    }

    public static void framebufferTexture2D(int type, int target, int attachment, int textarget, int texture, int level) {
        switch (type) {
            case 0: {
                GlStateManager._glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
            }
        }
    }

    public static void bindRenderbuffer(int type, int target, int renderbuffer) {
        switch (type) {
            case 0: {
                GlStateManager._glBindRenderbuffer((int)target, (int)renderbuffer);
            }
        }
    }

    public static void renderbufferStorage(int type, int target, int internalFormat, int width, int height) {
        switch (type) {
            case 0: {
                GlStateManager._glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
            }
        }
    }

    public static void framebufferRenderbuffer(int type, int target, int attachment, int renderBufferTarget, int renderBuffer) {
        switch (type) {
            case 0: {
                GlStateManager._glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
            }
        }
    }

    public void m_83947_(boolean p_147610_1_) {
        ImprovedFramebuffer.beginWrite(this.type, 36160, this.f_83920_);
        if (p_147610_1_) {
            GlStateManager._viewport((int)0, (int)0, (int)this.f_83917_, (int)this.f_83918_);
        }
    }

    public void m_83970_() {
        ImprovedFramebuffer.beginWrite(this.type, 36160, 0);
    }

    public void m_83956_() {
        GlStateManager._bindTexture((int)this.colorTextureId);
        RenderSystem.setShaderTexture((int)0, (int)this.colorTextureId);
    }

    public void m_83963_() {
        GlStateManager._bindTexture((int)0);
    }

    public void m_83936_(int framebufferFilterIn) {
        this.f_83922_ = framebufferFilterIn;
        GlStateManager._bindTexture((int)this.colorTextureId);
        GlStateManager._texParameter((int)3553, (int)10241, (int)framebufferFilterIn);
        GlStateManager._texParameter((int)3553, (int)10240, (int)framebufferFilterIn);
        GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
        GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
        GlStateManager._bindTexture((int)0);
    }

    public int getFramebufferTexture() {
        return this.colorTextureId;
    }

    public void setFramebufferTexture(int textureId) {
        if (textureId != this.colorTextureId) {
            this.colorTextureId = textureId;
            if (textureId != 0) {
                ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.colorTextureId, 0);
            }
        }
    }

    public void generateMipmaps() {
        switch (this.type) {
            case 0: {
                GL30.glGenerateMipmap((int)3553);
            }
        }
    }

    public int getType() {
        return this.type;
    }
}

