/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFRecipes;
import twilightforest.item.recipe.UncraftingRecipe;

public abstract class UncraftingRecipeProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<UncraftingRecipe, String[]> builders = Maps.newLinkedHashMap();

    public UncraftingRecipeProvider(PackOutput output, String modId, ExistingFileHelper helper) {
        this.output = output;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerUncraftingRecipes();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.builders.clear();
        this.registerUncraftingRecipes();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.builders.forEach((uncraftingRecipe, pattern) -> {
            List<UncraftingRecipe> list = this.builders.keySet().stream().filter(s -> {
                String name = s.m_6423_().m_135815_();
                return this.missing(name) && !this.builders.containsKey(uncraftingRecipe);
            }).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Uncrafting recipe: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((UncraftingRecipe)uncraftingRecipe, (String[])pattern);
            Path path = this.createPath(new ResourceLocation(this.modId, uncraftingRecipe.m_6423_().m_135815_()));
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)obj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private boolean missing(String name) {
        return !this.helper.exists(new ResourceLocation(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "uncrafting"));
    }

    private Path createPath(ResourceLocation name) {
        return this.output.m_245114_().resolve("data/" + name.m_135827_() + "/recipes/uncrafting/" + name.m_135815_() + ".json");
    }

    private JsonObject serializeToJson(UncraftingRecipe uncraftingRecipe, String[] pattern) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", Objects.requireNonNull(ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)((RecipeSerializer)TFRecipes.UNCRAFTING_SERIALIZER.get()))).toString());
        jsonobject.add("ingredient", uncraftingRecipe.ingredient().m_43942_());
        jsonobject.addProperty("count", (Number)uncraftingRecipe.count());
        jsonobject.addProperty("cost", (Number)uncraftingRecipe.cost());
        JsonArray jsonarray = new JsonArray();
        for (String line : pattern) {
            jsonarray.add(line);
        }
        jsonobject.add("pattern", (JsonElement)jsonarray);
        HashMap<Character, Ingredient> keyedPattern = new HashMap<Character, Ingredient>();
        for (String s : pattern) {
            for (int x = 0; x < uncraftingRecipe.width(); ++x) {
                char key = s.charAt(x);
                if (key == ' ' || keyedPattern.containsKey(Character.valueOf(key))) continue;
                keyedPattern.put(Character.valueOf(key), (Ingredient)uncraftingRecipe.m_7527_().get(keyedPattern.size()));
            }
        }
        JsonObject keyObject = new JsonObject();
        for (Map.Entry entry : keyedPattern.entrySet()) {
            keyObject.add(((Character)entry.getKey()).toString(), ((Ingredient)entry.getValue()).m_43942_());
        }
        jsonobject.add("key", (JsonElement)keyObject);
        return jsonobject;
    }

    public String m_6055_() {
        return this.modId + " Uncrafting Recipes";
    }

    public void addUncraftingRecipe(String name, Ingredient input, int count, int cost, String[] pattern, Ingredient ... output) {
        int width = pattern[0].length();
        int height = pattern.length;
        if (width > 3 || height > 3) {
            TwilightForestMod.LOGGER.error("The pattern must be 3x3 in size, or smaller!");
            return;
        }
        if (width == 0) {
            TwilightForestMod.LOGGER.error("A pattern line can not be empty!");
            return;
        }
        for (String s : pattern) {
            if (s.length() == width) continue;
            TwilightForestMod.LOGGER.error("Each line of a recipe pattern must be the same length!");
            return;
        }
        this.builders.put(new UncraftingRecipe(new ResourceLocation(name), cost, width, height, input, count, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])output)), pattern);
    }
}

