/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.util.LandmarkUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class TFWeatherRenderer {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation SPARKLES_TEXTURE = TwilightForestMod.getEnvTexture("sparkles.png");
    private static final float[] rainxs = new float[1024];
    private static final float[] rainzs = new float[1024];
    private static int rendererUpdateCount;
    private static BoundingBox protectedBox;
    private static final Random random;
    private static float urGhastRain;
    public static boolean urGhastAlive;
    private static int rainSoundTime;

    public TFWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                TFWeatherRenderer.rainxs[i << 5 | j] = -f1 / f2;
                TFWeatherRenderer.rainzs[i << 5 | j] = f / f2;
            }
        }
    }

    public static void tick() {
        ++rendererUpdateCount;
    }

    public static boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTicks, LightTexture lightmap, double camX, double camY, double camZ) {
        Minecraft mc = Minecraft.m_91087_();
        TFWeatherRenderer.renderNormalWeather(lightmap, level, partialTicks, camX, camY, camZ, Math.max(urGhastRain, level.m_46722_(partialTicks)));
        if (LandmarkUtil.isProgressionEnforced((Level)level) && mc.f_91074_ != null && !mc.f_91074_.m_7500_() && !mc.f_91074_.m_5833_()) {
            TFWeatherRenderer.renderLockedBiome(partialTicks, level, mc, lightmap, mc.f_91074_, camX, camY, camZ);
            TFWeatherRenderer.renderLockedStructure(partialTicks, mc, lightmap, camX, camY, camZ);
        }
        return true;
    }

    public static void renderNormalWeather(LightTexture lightmap, ClientLevel level, float ticks, double x, double y, double z, float rainLevel) {
        if (rainLevel > 0.0f) {
            lightmap.m_109896_();
            int i = Mth.m_14107_((double)x);
            int j = Mth.m_14107_((double)y);
            int k = Mth.m_14107_((double)z);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int range = 5;
            if (Minecraft.m_91405_()) {
                range = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)rendererUpdateCount + ticks;
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - range; j1 <= k + range; ++j1) {
                for (int k1 = i - range; k1 <= i + range; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)rainxs[l1] * 0.5;
                    double d1 = (double)rainzs[l1] * 0.5;
                    blockpos$mutableblockpos.m_122178_(k1, 0, j1);
                    Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                    if (!biome.m_264473_()) continue;
                    int i2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).m_123342_();
                    int j2 = j - range;
                    int k2 = j + range;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = Math.max(i2, j);
                    if (j2 == k2) continue;
                    Random random = new Random((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L);
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    if (biome.m_198906_((BlockPos)blockpos$mutableblockpos)) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RAIN_TEXTURES);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = rendererUpdateCount + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + ticks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)k1 + 0.5 - x;
                        double d4 = (double)j1 + 0.5 - z;
                        float f4 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)range;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * rainLevel;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)k2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)k2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)j2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)j2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 == 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_TEXTURES);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f6 = -((float)(rendererUpdateCount & 0x1FF) + ticks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - x;
                    double d5 = (double)j1 + 0.5 - z;
                    float f9 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)range;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * rainLevel;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)k2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)k2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)j2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)j2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.m_109891_();
        }
    }

    private static void renderLockedBiome(float partialTicks, ClientLevel level, Minecraft mc, LightTexture lightmap, LocalPlayer player, double xIn, double yIn, double zIn) {
        if (TFWeatherRenderer.isNearLockedBiome((Level)level, (Entity)player)) {
            lightmap.m_109896_();
            int x0 = Mth.m_14107_((double)xIn);
            int y0 = Mth.m_14107_((double)yIn);
            int z0 = Mth.m_14107_((double)zIn);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tessellator.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int range = 5;
            if (Minecraft.m_91405_()) {
                range = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            Enum currentType = null;
            float combinedTicks = (float)rendererUpdateCount + partialTicks;
            RenderSystem.setShader(GameRenderer::m_172829_);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int z = z0 - range; z <= z0 + range; ++z) {
                block7: for (int x = x0 - range; x <= x0 + range; ++x) {
                    int idx = (z - z0 + 16) * 32 + x - x0 + 16;
                    double rx = (double)rainxs[idx] * 0.5;
                    double ry = (double)rainzs[idx] * 0.5;
                    blockpos$mutableblockpos.m_122178_(x, 0, z);
                    Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                    if (TFGenerationSettings.isBiomeSafeFor(biome, (Entity)player)) continue;
                    int groundY = 0;
                    int minY = y0 - range;
                    int maxY = y0 + range;
                    if (minY < groundY) {
                        minY = groundY;
                    }
                    if (maxY < groundY) {
                        maxY = groundY;
                    }
                    int y = Math.max(groundY, y0);
                    if (minY == maxY) continue;
                    random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L);
                    RenderType nextType = TFWeatherRenderer.getRenderType(biome);
                    if (nextType == null) continue;
                    if (currentType != nextType) {
                        if (currentType != null) {
                            tessellator.m_85914_();
                        }
                        currentType = nextType;
                        RenderSystem._setShaderTexture((int)0, (ResourceLocation)nextType.getTextureLocation());
                        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    switch (1.$SwitchMap$twilightforest$client$renderer$TFWeatherRenderer$RenderType[currentType.ordinal()]) {
                        case 1: 
                        case 2: {
                            float d5 = -((float)(rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                            double d6 = (double)((float)x + 0.5f) - xIn;
                            double d7 = (double)((float)z + 0.5f) - zIn;
                            float f3 = Mth.m_14116_((float)((float)(d6 * d6 + d7 * d7))) / (float)range;
                            float f4 = (1.0f - f3 * f3) * 0.5f + 0.5f;
                            blockpos$mutableblockpos.m_122178_(x, y, z);
                            int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                            int k3 = j3 >> 16 & 0xFFFF;
                            int l3 = j3 & 0xFFFF;
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f, (float)minY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f, (float)minY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f, (float)maxY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f, (float)maxY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            continue block7;
                        }
                        case 3: {
                            float d8 = 0.0f;
                            float d9 = random.nextFloat() + combinedTicks * 0.01f * (float)random.nextGaussian();
                            float d10 = random.nextFloat() + combinedTicks * (float)random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = Mth.m_14116_((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float r = random.nextFloat() * 0.3f;
                            float g = random.nextFloat() * 0.3f;
                            float b = random.nextFloat() * 0.3f;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            continue block7;
                        }
                        case 4: {
                            float d8 = -((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = random.nextFloat() + combinedTicks * 0.01f * (float)random.nextGaussian();
                            float d10 = random.nextFloat() + combinedTicks * (float)random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = Mth.m_14116_((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            float color = random.nextFloat() * 0.2f + 0.8f;
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            continue block7;
                        }
                        case 5: {
                            float d8 = -((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = 0.0f;
                            float d10 = random.nextFloat() + combinedTicks * (float)random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = Mth.m_14116_((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * random.nextFloat();
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            float z1 = (float)yIn * 0.125f;
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)range, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, d8 + d10 - z1).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)range, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, d8 + d10 - z1).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                            float pV = (float)range * 0.25f + d8 + d10 - z1;
                            bufferBuilder.m_5483_((double)x - xIn + rx + 0.5, (double)(-range), (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, pV).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                            bufferBuilder.m_5483_((double)x - xIn - rx + 0.5, (double)(-range), (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, pV).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                        }
                    }
                }
            }
            if (currentType != null) {
                tessellator.m_85914_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.m_109891_();
        }
    }

    private static void renderLockedStructure(float partialTicks, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        if (TFWeatherRenderer.isNearLockedStructure(xIn, zIn)) {
            lightmap.m_109896_();
            int i = Mth.m_14107_((double)xIn);
            int j = Mth.m_14107_((double)yIn);
            int k = Mth.m_14107_((double)zIn);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int range = 5;
            if (Minecraft.m_91405_()) {
                range = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.m_91085_());
            int j1 = -1;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - range; k1 <= k + range; ++k1) {
                for (int l1 = i - range; l1 <= i + range; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)rainxs[i2] * 0.5;
                    double d4 = (double)rainzs[i2] * 0.5;
                    if (protectedBox == null || !protectedBox.m_71019_(l1, k1, l1, k1)) continue;
                    int structureMin = protectedBox.m_162396_() - 4;
                    int structureMax = protectedBox.m_162400_() + 4;
                    int k2 = j - range;
                    int l2 = j + range * 2;
                    if (k2 < structureMin) {
                        k2 = structureMin;
                    }
                    if (l2 < structureMin) {
                        l2 = structureMin;
                    }
                    if (k2 > structureMax) {
                        k2 = structureMax;
                    }
                    if (l2 > structureMax) {
                        l2 = structureMax;
                    }
                    if (k2 == l2) continue;
                    Random random = new Random((long)l1 * (long)l1 * 3121L + (long)l1 * 45238971L ^ (long)k1 * (long)k1 * 418711L + (long)k1 * 13761L);
                    blockpos$mutableblockpos.m_122178_(l1, k2, k1);
                    if (j1 != 0) {
                        if (j1 >= 0) {
                            tessellator.m_85914_();
                        }
                        j1 = 0;
                        RenderSystem._setShaderTexture((int)0, (ResourceLocation)SPARKLES_TEXTURE);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float d5 = -((float)(rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                    double d6 = (double)((float)l1 + 0.5f) - xIn;
                    double d7 = (double)((float)k1 + 0.5f) - zIn;
                    float f3 = Mth.m_14116_((float)((float)(d6 * d6 + d7 * d7))) / (float)range;
                    float f = random.nextFloat();
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    int j3 = 0xF000F0;
                    int k3 = j3 >> 16 & 0xFFFF;
                    int l3 = j3 & 0xFFFF;
                    bufferbuilder.m_5483_((double)l1 - xIn - d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn - d4 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                    bufferbuilder.m_5483_((double)l1 - xIn + d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn + d4 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                    bufferbuilder.m_5483_((double)l1 - xIn + d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn + d4 + 0.5).m_7421_(1.0f, (float)l2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                    bufferbuilder.m_5483_((double)l1 - xIn - d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn - d4 + 0.5).m_7421_(0.0f, (float)l2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                }
            }
            if (j1 == 0) {
                tessellator.m_85914_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightmap.m_109891_();
        }
    }

    private static boolean isNearLockedBiome(Level world, Entity viewEntity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int range = 15;
        int px = Mth.m_14107_((double)viewEntity.m_20185_());
        int pz = Mth.m_14107_((double)viewEntity.m_20189_());
        for (int z = pz - 15; z <= pz + 15; ++z) {
            for (int x = px - 15; x <= px + 15; ++x) {
                Biome biome = (Biome)world.m_204166_((BlockPos)pos.m_122178_(x, 0, z)).m_203334_();
                if (TFGenerationSettings.isBiomeSafeFor(biome, viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isNearLockedStructure(double xIn, double zIn) {
        int range = 15;
        int px = Mth.m_14107_((double)xIn);
        int pz = Mth.m_14107_((double)zIn);
        return protectedBox != null && protectedBox.m_71019_(px - 15, pz - 15, px + 15, pz + 15);
    }

    public static void setProtectedBox(BoundingBox protectedBox) {
        TFWeatherRenderer.protectedBox = protectedBox;
    }

    @Nullable
    private static RenderType getRenderType(Biome b) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        ResourceLocation biome = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)b);
        if (TFBiomes.SNOWY_FOREST.m_135782_().equals((Object)biome) || TFBiomes.GLACIER.m_135782_().equals((Object)biome)) {
            return RenderType.BLIZZARD;
        }
        if (TFBiomes.SWAMP.m_135782_().equals((Object)biome)) {
            return RenderType.MOSQUITO;
        }
        if (TFBiomes.FIRE_SWAMP.m_135782_().equals((Object)biome)) {
            return RenderType.ASHES;
        }
        if (TFBiomes.DARK_FOREST.m_135782_().equals((Object)biome) || TFBiomes.DARK_FOREST_CENTER.m_135782_().equals((Object)biome)) {
            return random.nextInt(2) == 0 ? RenderType.DARK_STREAM : null;
        }
        if (TFBiomes.HIGHLANDS.m_135782_().equals((Object)biome) || TFBiomes.THORNLANDS.m_135782_().equals((Object)biome) || TFBiomes.FINAL_PLATEAU.m_135782_().equals((Object)biome)) {
            return RenderType.BIG_RAIN;
        }
        return null;
    }

    public static boolean tickRain(ClientLevel level, int ticks, BlockPos blockpos) {
        if (urGhastAlive) {
            urGhastRain = Math.min(1.0f, urGhastRain + 0.1f);
            urGhastAlive = false;
        } else {
            urGhastRain = Math.max(0.0f, urGhastRain - 0.02f);
        }
        float rainLevel = Math.max(level.m_46722_(1.0f), urGhastRain) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        if (rainLevel > 0.0f) {
            RandomSource randomsource = RandomSource.m_216335_((long)((long)ticks * 312987231L));
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * rainLevel * rainLevel) / (Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = randomsource.m_188503_(21) - 10;
                int l = randomsource.m_188503_(21) - 10;
                BlockPos blockpos2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos.m_7918_(k, 0, l));
                Biome biome = (Biome)level.m_204166_(blockpos2).m_203334_();
                if (blockpos2.m_123342_() <= level.m_141937_() || blockpos2.m_123342_() > blockpos.m_123342_() + 10 || blockpos2.m_123342_() < blockpos.m_123342_() - 10 || !biome.m_264473_() || !biome.m_198906_(blockpos2)) continue;
                blockpos1 = blockpos2.m_7495_();
                if (Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
                double d0 = randomsource.m_188500_();
                double d1 = randomsource.m_188500_();
                BlockState blockstate = level.m_8055_(blockpos1);
                FluidState fluidstate = level.m_6425_(blockpos1);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)level, blockpos1);
                double d2 = voxelshape.m_83290_(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.m_76155_((BlockGetter)level, blockpos1);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.m_205070_(FluidTags.f_13132_) && !blockstate.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockstate) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                level.m_7106_((ParticleOptions)particleoptions, (double)blockpos1.m_123341_() + d0, (double)blockpos1.m_123342_() + d4, (double)blockpos1.m_123343_() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && randomsource.m_188503_(4) < rainSoundTime++) {
                rainSoundTime = 0;
                if (blockpos1.m_123342_() > blockpos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockpos).m_123342_() > Mth.m_14143_((float)blockpos.m_123342_())) {
                    level.m_245747_(blockpos1, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                } else {
                    level.m_245747_(blockpos1, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
        return true;
    }

    static {
        random = new Random();
        urGhastRain = 0.0f;
        urGhastAlive = false;
    }

    private static enum RenderType {
        BLIZZARD("blizzard.png"),
        MOSQUITO("mosquitoes.png"),
        ASHES("ashes.png"),
        DARK_STREAM("darkstream.png"),
        BIG_RAIN("bigrain.png");

        private final ResourceLocation textureLocation;

        private RenderType(String textureName) {
            this.textureLocation = TwilightForestMod.getEnvTexture(textureName);
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }
    }
}

