/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.init.TFBlockEntities;

public class SkullCandleBlockEntity
extends SkullBlockEntity {
    private int candleColor;
    private int candleAmount;
    private int animationTickCount;
    private boolean isAnimating;

    public SkullCandleBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public SkullCandleBlockEntity(BlockPos pos, BlockState state, int color, int amount) {
        super(pos, state);
        this.candleColor = color;
        this.candleAmount = amount;
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)TFBlockEntities.SKULL_CANDLE.get();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("CandleColor", this.candleColor);
        if (this.candleAmount != 0) {
            tag.m_128405_("CandleAmount", this.candleAmount);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.candleColor = tag.m_128451_("CandleColor");
        this.candleAmount = tag.m_128451_("CandleAmount");
    }

    public int getCandleColor() {
        return this.candleColor;
    }

    public int getCandleAmount() {
        return this.candleAmount;
    }

    public void setCandleColor(int color) {
        this.candleColor = color;
    }

    public void setCandleAmount(int amount) {
        this.candleAmount = amount;
    }

    public void incrementCandleAmount() {
        ++this.candleAmount;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SkullCandleBlockEntity entity) {
        if (level.m_276867_(pos)) {
            entity.isAnimating = true;
            ++entity.animationTickCount;
        } else {
            entity.isAnimating = false;
        }
    }

    public float m_261082_(float pPartialTick) {
        return this.isAnimating ? (float)this.animationTickCount + pPartialTick : (float)this.animationTickCount;
    }
}

