/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.glfw.GLFW;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class ControlsHandler {
    protected IXaeroMinimap modMain;
    protected XaeroMinimapSession minimapSession;
    protected WaypointsManager waypointsManager;
    protected MinimapProcessor minimap;

    public ControlsHandler(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.minimap = minimapSession.getMinimapProcessor();
    }

    public void setKeyState(KeyMapping kb, boolean pressed) {
        KeyMapping.m_90837_((InputConstants.Key)kb.getKey(), (boolean)pressed);
    }

    public boolean isDown(KeyMapping kb) {
        if (kb.getKey().m_84873_() == -1) {
            return false;
        }
        if (kb.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)kb.getKey().m_84873_()) == 1;
        }
        if (kb.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)kb.getKey().m_84873_());
        }
        return false;
    }

    public void keyDownPre(KeyMapping kb) {
    }

    public void keyDownPost(KeyMapping kb) {
    }

    public void keyDown(KeyMapping kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.m_91087_();
        if (!tickEnd) {
            WaypointWorld currentWorld;
            Screen currentEscScreen;
            Screen current;
            this.keyDownPre(kb);
            if (kb == ModSettings.newWaypoint && this.modMain.getSettings().waypointsGUI(this.waypointsManager)) {
                mc.m_91152_((Screen)new GuiAddWaypoint(this.modMain, this.waypointsManager, null, Lists.newArrayList(), this.waypointsManager.getCurrentContainerID().split("/")[0], this.waypointsManager.getCurrentWorld(), true));
            }
            if (kb == ModSettings.keyWaypoints && this.modMain.getSettings().waypointsGUI(this.waypointsManager)) {
                current = mc.f_91080_;
                currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                mc.m_91152_((Screen)new GuiWaypoints(this.modMain, this.minimapSession, current, currentEscScreen));
            }
            if (kb == ModSettings.keyLargeMap) {
                this.minimapSession.getMinimapProcessor().setEnlargedMap(this.modMain.getSettings().enlargedMinimapAToggle ? !this.minimapSession.getMinimapProcessor().isEnlargedMap() : true);
                this.minimap.setToResetImage(true);
                this.minimap.instantZoom();
            }
            if (kb == ModSettings.keyToggleMap && !mc.f_91074_.m_21023_(Effects.NO_MINIMAP) && !mc.f_91074_.m_21023_(Effects.NO_MINIMAP_HARMFUL)) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.MINIMAP);
            }
            if (kb == ModSettings.keyToggleWaypoints) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.INGAME_WAYPOINTS);
            }
            if (kb == ModSettings.keyToggleMapWaypoints) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.WAYPOINTS);
            }
            if (kb == ModSettings.keyToggleSlimes) {
                try {
                    if (this.modMain.getSettings().customSlimeSeedNeeded(this.minimapSession) && this.modMain.getSettings().getBooleanValue(ModOptions.OPEN_SLIME_SETTINGS)) {
                        current = mc.f_91080_;
                        currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                        Minecraft.m_91087_().m_91152_((Screen)new GuiSlimeSeed(this.modMain, this.waypointsManager, current, currentEscScreen));
                    } else {
                        this.modMain.getSettings().slimeChunks = !this.modMain.getSettings().slimeChunks;
                        this.modMain.getSettings().saveSettings();
                    }
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleGrid) {
                try {
                    this.modMain.getSettings().chunkGrid = -this.modMain.getSettings().chunkGrid - 1;
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyInstantWaypoint && !mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS) && !mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_HARMFUL)) {
                this.waypointsManager.createTemporaryWaypoints(this.waypointsManager.getCurrentWorld(), OptimizedMath.myFloor(mc.f_91074_.m_20185_()), OptimizedMath.myFloor(mc.f_91074_.m_20186_() + 0.0625), OptimizedMath.myFloor(mc.f_91074_.m_20189_()));
            }
            if (kb == ModSettings.keySwitchSet && (currentWorld = this.waypointsManager.getCurrentWorld()) != null) {
                String[] keys = currentWorld.getSets().keySet().toArray(new String[0]);
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null || !keys[i].equals(currentWorld.getCurrent())) continue;
                    currentWorld.setCurrent(keys[(i + 1) % keys.length]);
                    break;
                }
                this.waypointsManager.updateWaypoints();
                this.waypointsManager.setChanged = System.currentTimeMillis();
                try {
                    this.modMain.getSettings().saveWaypoints(currentWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyAllSets) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.WAYPOINTS_ALL_SETS);
            }
            if (kb == ModSettings.keyLightOverlay) {
                this.modMain.getSettings().lightOverlayType = this.modMain.getSettings().lightOverlayType == 0 ? 1 : (this.modMain.getSettings().lightOverlayType *= -1);
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (!this.minimapSession.getMinimapProcessor().isEnlargedMap() || this.modMain.getSettings().zoomOnEnlarged == 0) {
                int zoomChange = 0;
                if (kb == ModSettings.keyBindZoom) {
                    zoomChange = 1;
                }
                if (kb == ModSettings.keyBindZoom1) {
                    zoomChange = -1;
                }
                if (zoomChange != 0) {
                    this.modMain.getSettings().changeZoom(zoomChange);
                    try {
                        this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }
            if (kb == ModSettings.keyToggleRadar) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.RADAR_DISPLAYED);
            } else if (kb == ModSettings.keyManualCaveMode) {
                this.minimapSession.getMinimapProcessor().toggleManualCaveMode();
            } else if (kb == ModSettings.keyToggleTrackedPlayers) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.TRACKED_PLAYERS);
            } else if (kb == ModSettings.keyTogglePacChunkClaims) {
                if (this.modMain.getSupportMods().worldmap() && this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                    this.modMain.getSupportMods().worldmapSupport.toggleChunkClaims();
                } else {
                    this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.PAC_CLAIMS);
                }
            }
            this.keyDownPost(kb);
        }
    }

    public void keyUpPre(KeyMapping kb) {
    }

    public void keyUpPost(KeyMapping kb) {
    }

    public void keyUp(KeyMapping kb, boolean tickEnd) {
        if (!tickEnd) {
            this.keyUpPre(kb);
            if (!this.modMain.getSettings().enlargedMinimapAToggle && kb == ModSettings.keyLargeMap) {
                this.minimapSession.getMinimapProcessor().setEnlargedMap(false);
                this.minimap.setToResetImage(true);
                this.minimap.instantZoom();
            }
            this.keyUpPost(kb);
        }
    }
}

